jQuery(document).ready(function(){
	
	$('#numano009').rup_combo({
		source : [new Date().getFullYear(), new Date().getFullYear()-1], 
		width: 100,
		rowStriping:true,
		ordered:false,
		blank:""
	});

	$('#id008tipoPlan').rup_combo({
		source : "/ab03bAmiantoWar/ab03b08t00/comboTipoPlan",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:true,
		blank:""
	});	
	
	$('#id001Fase').rup_combo({
		source : "/ab03bAmiantoWar/ab03b01t00/comboFase",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 320,
		rowStriping:true,
		inputText:true,
		ordered:false,
		selected: $("#id001Fase").val(),
		blank:""
	});	
	
	$('#id002Tramite').rup_combo({
		source : "/ab03bAmiantoWar/ab03b02t00/comboTramite",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 340,
		rowStriping:true,
		inputText:true,
		ordered:false,
		parent:["id001Fase"],
		blank:""
	});
	
	$("#fecRegDesde").rup_date();
	$("#fecRegHasta").rup_date();
	
	jQuery.validator.addMethod("validacionFechas", function(value, element, params) {
		var fechaDesde=$("#fecRegDesde").val();
		var fechaHasta=$("#fecRegHasta").val();
		if(fechaDesde!='' && fechaHasta!=''){
			fechaDesde=new Date(fechaDesde.substring(6,10),fechaDesde.substring(3,5),fechaDesde.substring(0,2));
			fechaHasta=new Date(fechaHasta.substring(6,10),fechaHasta.substring(3,5),fechaHasta.substring(0,2));
			if(fechaDesde>fechaHasta){
				return false;
			}else{
				return true;
			}
		}else{
			return true;
		}
		
	});	
	
	if(esUsuarioModificacion){
		$("#solTelematica").rup_table({
			url: "../ab03b09t00",
			colNames: [
				"id009",
				$.rup.i18n.app.expedientes.procesar,		           
				$.rup.i18n.app.expedientes.expediente,
				$.rup.i18n.app.expedientes.plan,
				$.rup.i18n.app.expedientes.numRegistro,
				$.rup.i18n.app.expedientes.fecReg,
				$.rup.i18n.app.expedientes.cifNif,
				$.rup.i18n.app.expedientes.razonSocial,
				$.rup.i18n.app.expedientes.fase,
				$.rup.i18n.app.expedientes.tramite	
			],
			colModel: [
				{ 	name: "id009",
					align: "right", 
					width: 90, 
					sortable: false,
					resizable: false, 
					hidden: true
				},
				{
					width:72,
					name: "procesar", 
					label: $.rup.i18n.app.expedientes.procesar, 
					sortable:false,
					align: "center", 
					formatter:function (cellval, opts, rwd, act) {
						return ("<input type=\"button\" name=\"ver\" value="+$.rup.i18n.app.expedientes.procesar+" onclick=\"javascript:procesar('"+rwd.expRelac009+"',"+ rwd.id009 +")\" >");
					}
				},
				{ 	name: "expRelac009",
					align: "right", 
					width: 130, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "planDescR"+ $.rup_utils.capitalizedLang(),
					align: "center", 
					width: 33, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "numreg009", 
					align: "right", 
					width: 136, 
					ruptype: "datepicker", 
					resizable: true, 
					sortable: true
				},
				{ 	name: "fregistro009Str", 
					align: "center", 
					width: 100, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "remitenteId009", 
					align: "center", 
					width: 88, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "remitenteNom009", 
					align: "left", 
					width: 250,  
					resizable: true, 
					sortable: true
				},
				{ 	name: "faseDesc" + $.rup_utils.capitalizedLang(), 
					align: "left", 
					width: 220, 
					ruptype: "combo", 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "tramiteDesc" + $.rup_utils.capitalizedLang(), 
					align: "left", 
					width: 220, 
					ruptype: "combo", 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				}
	        ],
	
	        model:"Ab03b09t00",
	        usePlugins:[
	        	"feedback",
	        	"fluid",
	        	"toolbar",
	        	"formEdit",
	        	"filter",
	        	"report"
	         	],
			primaryKey: "id009",
			sortname: "fregistro009",
			sortorder: "desc",
			loadOnStartUp: true,
			rowNum:10,
			feedback:{
				config:{
					block: false
				}
			},
			createDefaultToolButtons:false,
	        buttons:[],
	        core:{
				operations:{
					"detalleExpediente": {
						name:	$.rup.i18n.app.expedientes.acceder,
						icon:	"rup-icon rup-icon-edit",
						enabled: function(){
							return true;
						},
						callback: function(key, options){
							solTelematica_redirigirDetalle();
						}
					}
				},
		    	showOperations:{
		    		"add": false,
		    		"edit": false,
		    		"delete": false,
		    		"clone": false
		    	}
	        },
	        report: {
	        	buttons: [{ 
	        			'id': 'reports', 
	        			'i18nCaption': $.rup.i18n.app.botones.informes, 
	        			right: true,
	              	 	'buttons': [
	        	          { i18nCaption: "XLS", css: "xls", url: "../ab03b09t00/xlsReport"},
	        	          { i18nCaption: "XLSX", css: "xls", url: "../ab03b09t00/xlsxReport" },
	        	          { i18nCaption: "PDF", css: "pdf", url: "../ab03b09t00/pdfReport" }
	        	      ]
	        }
	        	]
	        }
		}).ready(function(){
			$("#solTelematica_toolbar").rup_toolbar({buttons:[]}).addClass("clsCustomToolbar");
		});
	}else{
		$("#solTelematica").rup_table({
			url: "../ab03b09t00",
			colNames: [
				"id009",		           
				$.rup.i18n.app.expedientes.expediente,
				$.rup.i18n.app.expedientes.plan,
				$.rup.i18n.app.expedientes.numRegistro,
				$.rup.i18n.app.expedientes.fecReg,
				$.rup.i18n.app.expedientes.cifNif,
				$.rup.i18n.app.expedientes.razonSocial,
				$.rup.i18n.app.expedientes.fase,
				$.rup.i18n.app.expedientes.tramite			
			],
			colModel: [
				{ 	name: "id009",
					align: "right", 
					width: 90, 
					sortable: false,
					resizable: false, 
					hidden: true
				},
				{ 	name: "expRelac009",
					align: "right", 
					width: 130, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "planDescR"+ $.rup_utils.capitalizedLang(),
					align: "center", 
					width: 33, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "numreg009", 
					align: "right", 
					width: 136, 
					ruptype: "datepicker", 
					resizable: true, 
					sortable: true
				},
				{ 	name: "fregistro009Str", 
					align: "center", 
					width: 100, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "remitenteId009", 
					align: "center", 
					width: 88, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "remitenteNom009", 
					align: "left", 
					width: 250,  
					resizable: true, 
					sortable: true
				},
				{ 	name: "faseDesc" + $.rup_utils.capitalizedLang(), 
					align: "left", 
					width: 220, 
					ruptype: "combo", 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "tramiteDesc" + $.rup_utils.capitalizedLang(), 
					align: "left", 
					width: 220, 
					ruptype: "combo", 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
	        ],

	        model:"Ab03b09t00",
	        usePlugins:[
	        	"feedback",
	        	"fluid",
	        	"toolbar",
	        	"formEdit",
	        	"filter",
	        	"report"
	         	],
			primaryKey: "id009",
			sortname: "fregistro009",
			sortorder: "desc",
			loadOnStartUp: true,
			rowNum:10,
			feedback:{
				config:{
					block: false
				}
			},
			createDefaultToolButtons:false,
	        buttons:[],
	        core:{
				operations:{
					"detalleExpediente": {
						name:	$.rup.i18n.app.expedientes.acceder,
						icon:	"rup-icon rup-icon-edit",
						enabled: function(){
							return true;
						},
						callback: function(key, options){
							solTelematica_redirigirDetalle();
						}
					}
				},
		    	showOperations:{
		    		"add": false,
		    		"edit": false,
		    		"delete": false,
		    		"clone": false
		    	}
	        },
	        report: {
	        	buttons: [{ 
	        			'id': 'reports', 
	        			'i18nCaption': $.rup.i18n.app.botones.informes, 
	        			right: true,
	              	 	'buttons': [
	        	          { i18nCaption: "XLS", css: "xls", url: "../ab03b09t00/xlsReport"},
	        	          { i18nCaption: "XLSX", css: "xls", url: "../ab03b09t00/xlsxReport" },
	        	          { i18nCaption: "PDF", css: "pdf", url: "../ab03b09t00/pdfReport" }
	        	      ]
	        }
	        	]
	        }
		}).ready(function(){
			$("#solTelematica_toolbar").rup_toolbar({buttons:[]}).addClass("clsCustomToolbar");
		});
	}
			
	// Acceder al detalle haciendo doble click en el elemento
	$("#solTelematica").rup_table('setGridParam',{ ondblClickRow : function(rowid){ solTelematica_redirigirDetalle(); } });	
	
	$("#solTelematica_filter_form").rup_validate({
		feedback:$("#solTelematica_feedback"),
		liveCheckingErrors: false,
		rules:{
			"idProv010":{digits:true},
			"idAno010":{digits:true},
			"id010Exp":{digits:true},
			"fecRegDesde":{date:true, validacionFechas:true },
			"fecRegHasta":{date:true, validacionFechas:true }
		}
	});	
	
	$("#solTelematica").on("rupTable_beforeFilter",
		function(){
			if(ab03bUtils.form.validate($("#solTelematica_filter_form"))){	
				return true;
			} else {
				return false;
			}
		}
	);	
	
});

// Funcion que redirige al detalle de un expediente
function solTelematica_redirigirDetalle(){
	
	var idFila = $("#solTelematica").rup_grid('getGridParam', 'selrow');
	var fila =  $("#solTelematica").rup_grid('getRowData', idFila);
	
	if(fila && fila.id009){
		var pk = fila.id009;
		location.href = $.rup.CTX_PATH + "ab03b09t00/detalle/" + pk;
	}
}

function ocultar(capaAcordeon){
	$(capaAcordeon).toggle();
};

//Funcion limpiar
$('#solTelematica_filter_cleanLink').click(function(event){
	$("#fecRegHasta").val('');
	resetFiltro($("#solTelematica_filter_form"));
	
	//se borran los mensajes de errores que se muestran en el feedback
	$("#solTelematica_filter_form").validate().submitted = {};
	//se cierra el feedback
	$("#solTelematica_feedback").rup_feedback("close");
	
	$("#solTelematica").rup_table('filter'); 
	
	// se quitan las imagenes que marcan el error
	$(".rup-maint_validateIcon", $("#solTelematica_filter_form")).remove();
});

function procesar (expediente, id009){
	var urlCarga ="/ab03bAmiantoWar/ab03b09t00/procesar";
	waitDialog();
	
	$.rup_ajax({
    	url: urlCarga,
    	dataType: 'json',
    	data:{'expediente':expediente, 'id009':id009},
    	cache: false,
    	type: "GET",
    	contentType: 'application/json',
    	success: function (xhr, ajaxOptions) {
    		$.unblockUI();
    		url="/ab03bAmiantoWar/ab03b10t00/irDetalle/"+expediente;
    		window.location=url;
    	},
   		error: function (xhr, textStatus, errorThrown) {
   			$.unblockUI();
			var errorText = $.rup.rupAjaxDefaultError(xhr, textStatus, errorThrown);
			alert(errorText,"feedbackResolucion",true);
		}
    });
}
